<h3 class="mb-3 fw-bold">Katalog Perpustakaan</h3>
<div class="card border-0 shadow-sm">
    <div class="card-body">
        <div class="mb-3">
            <button class="btn btn-primary fw-bold" data-bs-toggle="modal" data-bs-target="#mBuku">
                <i class="bi bi-plus-lg me-1"></i> Tambah Buku
            </button>
        </div>

        <!-- Tambahkan class 'table-data' disini -->
        <table id="tabelBuku" class="table table-bordered table-hover w-100 table-data">
            <thead class="table-light">
                <tr>
                    <th>Judul Buku</th>
                    <th>Pengarang</th>
                    <th>Stok</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $q = mysqli_query($koneksi, "SELECT * FROM buku ORDER BY judul ASC"); 
                while($d = mysqli_fetch_array($q)){ 
                    // Logic Stok: Kalau < 5 merah (Warning)
                    $badge_stok = ($d['stok'] < 5) ? 'bg-danger' : 'bg-info text-dark';
                ?>
                <tr>
                    <td><b><?php echo $d['judul']; ?></b></td>
                    <td><?php echo $d['pengarang']; ?></td>
                    <td><span class="badge <?php echo $badge_stok; ?>"><?php echo $d['stok']; ?> Eks</span></td>
                    <td class="text-center">
                        <a href="?page=edit_buku&id=<?php echo $d['id']; ?>" class="btn btn-sm btn-warning py-0">Edit</a>
                        <a href="proses/act_perpus.php?aksi=hapus_buku&id=<?php echo $d['id']; ?>" class="btn btn-sm btn-danger py-0" onclick="return confirm('Hapus buku ini?')">X</a>
                    </td>
                </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Modal Tambah Buku -->
<div class="modal fade" id="mBuku">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="proses/act_perpus.php">
                <div class="modal-header"><h5>Tambah Buku Baru</h5></div>
                <div class="modal-body">
                    <input name="judul" class="form-control mb-2" placeholder="Judul Buku" required>
                    <input name="pengarang" class="form-control mb-2" placeholder="Pengarang" required>
                    <input name="stok" type="number" class="form-control" placeholder="Stok" required>
                </div>
                <div class="modal-footer">
                    <button type="submit" name="simpan_buku" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>